# Install and load necessary packages
if (!require("survival")) install.packages("survival")
if (!require("readxl")) install.packages("readxl")

library(survival)
library(readxl)

# Read data (ensure proper encoding)
data <- read_excel("model 2.xlsx")

# Convert categorical variables
data$Group <- as.factor(data$Group)
data$cci <- as.factor(data$cci)
data$sex <- as.factor(data$sex)
data$AE_admissions_past1y <- as.factor(data$AE_admissions_past1y)

# Build Cox proportional hazards model
cox_model <- coxph(Surv(Follow_up_time, AE) ~ Group + AE_admissions_past1y + 
                     cci + FEV1 + sex + BMI + age, data = data)

# Show model summary
cox_summary <- summary(cox_model)
print(cox_summary)

# Extract results into a dataframe
cox_results <- data.frame(
  Variable = rownames(cox_summary$coefficients),
  Coef = cox_summary$coefficients[, "coef"],
  HR = exp(cox_summary$coefficients[, "coef"]),
  Lower_CI = cox_summary$conf.int[, "lower .95"],
  Upper_CI = cox_summary$conf.int[, "upper .95"],
  SE = cox_summary$coefficients[, "se(coef)"],
  Z = cox_summary$coefficients[, "z"],
  P_value = cox_summary$coefficients[, "Pr(>|z|)"]
)

# Save results to CSV
write.csv(cox_results, "cox_model_results_model2.csv", 
          row.names = FALSE, fileEncoding = "UTF-8")
